package fr.asip.cps3.exemple.vues.ecrans.resultats;

import java.awt.GridBagLayout;

import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

import fr.asip.cps3.exemple.vues.FenetrePrincipale;
import fr.asip.cps3.exemple.vues.composants.GridBagHelper;
import fr.asip.cps3.exemple.vues.ecrans.EcranUtil;

/**
 * Classe permettant de modliser l'cran de rsultats de traitements spcifiques
 */
public class SortieResultatSpecifique extends SortieResultat {

	/**
	 * Constructeur
	 * @param fenetre La fentre qui doit contenir l'cran de rsultat
	 */
	public SortieResultatSpecifique(FenetrePrincipale fenetre) {
		super(fenetre);
		libelleOperation = new JLabel("Traitement : ");
	}
	
	/*
	 * (non-Javadoc)
	 * @see fr.asip.cps3.exemple.vues.ecrans.IEcran#affiche()
	 */
	public void affiche() {

    	JFrame fenetre = this.fenetre.getFenetre();

    	if(fenetre != null && fenetre.getContentPane() != null) {    	
    	
	    	EcranUtil.supprimeTousLesComposants(((JPanel)fenetre.getContentPane()));
	    	
	        // Cration du layout
	    	((JPanel)fenetre.getContentPane()).setBorder(new EmptyBorder(0, 0, 0, 0));
	        GridBagLayout layout = new GridBagLayout();
	        ((JPanel)fenetre.getContentPane()).setLayout(layout);
	        
	        // Ajout des composants
	        GridBagHelper g = new GridBagHelper(fenetre.getContentPane());
	        // Ligne 0
	        g.ajoute(libelleOperation, EcranUtil.styleLibelleSortie, 0, 0, 1, 1);
	        g.ajoute(texteOperation, EcranUtil.styleTexteSortie, 0, 1, 1, 4);
	        // Ligne 1
	        g.ajoute(libelleRetour, EcranUtil.styleLibelleSortieCodeRetour, 1, 0, 1, 1);
	        g.ajoute(texteRetour, EcranUtil.styleTexteSortieCodeRetour, 1, 1, 1, 4);
	        // Ligne 2
			if(barreStatut != null)
				barreStatut.setText(this.fenetre.getBarreStatut().getText());
	        g.ajoute(barreStatut, EcranUtil.styleBarreStatut, 2, 0, 1, 6);
	        
    	}             		
	}
}
